BERSERK_MAGIC = add_magic 
{ 
   ["fail"] =      function(chance) 
      msg_print("You cannot focus your energies!") 
      do_dec_stat(A_CON,1) 
   end, 
   ["stat"] =      A_CON, 
   -- Must return a number between 0 and 50 representing a level 
        -- If you tie the mkey to a skill, use this skill instead. 
   ["get_level"] = function() 
      return get_skill_scale(SKILL_BERSERK, 50) 
   end, 
   ["spell_list"] = 
   { 
      { 
         ["name"] = "Berserk Rage", 
         ["desc"] = "Increases your combat abilities.", 
         ["mana"]  =  1, 
         ["level"] =  1, 
         ["fail"]  = 10, 
         ["spell"] = function() 
            set_hero(20 + player.lev) 
            if (player.lev >= 10) then 
               set_shero(20 + player.lev) 
            end 
            return 
         end, 
         ["info"] = function() 
            return " dur "..(20 + player.lev) 
         end, 
      }, 
      { 
         ["name"] = "Bear Form", 
         ["desc"] = "Turns you into a bear.", 
         ["mana"]  =  5, 
         ["level"] = 10, 
         ["fail"]  = 30, 
         ["spell"] = function() 
            if (player.antimagic > 0) then 
               msg_print("Your anti-magic field disrupts your attempt.") 
               return 
            end 
            -- duration set as the power PWR_BEAR 
            return set_mimic(150 + player.lev * 10, resolve_mimic_name("Bear"), player.lev) 
         end, 
         ["info"] =      function() 
            return " dur "..(150 + player.lev * 10) 
         end, 
      }, 
      { 
         ["name"] = "Battle Shout", 
         ["desc"] = "It allows you to terrify all enemies within earshot.", 
         ["mana"] =  10, 
         ["level"] = 20, 
         ["fail"] =  50, 
         ["spell"] = function()  
            project_los(GF_AWAY_ALL, 3 * player.lev) 
         end, 
         ["info"] = function() 
            return "power "..3 * player.lev
         end, 
      }, 
      { 
         ["name"] = "Whirlwind attack", 
         ["desc"] = "It allows you to spin around and hit all monsters nearby.", 
         ["mana"] =  10, 
         ["level"] = 20, 
         ["fail"] =  50, 
         ["spell"] = function() 
            -- as the Tulkas spell Whirlwind 
            return fire_ball(GF_ATTACK, 0, 1, 1) 
         end, 
         ["info"] = function() 
            return "" 
         end, 
      }, 
      { 
         ["name"] = "Resist Fire & Iron", 
         ["desc"] = "Temporarily boosts AC and grants fire resistance.", 
         ["mana"] =  15, 
         ["level"] = 30, 
         ["fail"] =  50, 
         ["spell"] = function()
	    local dur = 100 + (2 * player.lev)
            if (player.antimagic > 0) then 
               msg_print("Your anti-magic field disrupts your attempt.") 
               return 
            end 
            set_oppose_fire(dur)
	    set_shield(dur, 50, 0, 0, 0)
         end, 
         ["info"] = function()
	    local dur = 100 + (2 * player.lev)
            return " dur "..dur 
         end, 
      }, 
   }, 
} 

-- This code is partially borrowed from vrak's "Berserk" module,
-- although I see no thematic reason for Nordic-style berserkers 
-- (as opposed to the Hengband variety) getting a digging bonus!

add_hooks
{
        -- Add the AC bonuses
        [HOOK_CALC_BONUS] = function()
            if get_class_name() == "Berserker" then
                -- AC bonus
                player.to_a = player.to_a + 10 + (player.lev / 2)
                player.dis_to_a = player.dis_to_a + 10 + (player.lev / 2)
		end
        end,

}

--- berserkers are allowed soft (non-dragon) armor only
function __hook_berserk_wear(obj) 
    local str = get_class_name() 
    local type = obj.tval
         if str == "Berserker" and (type == 37 or type == 38) then 
            return TRUE, -1 
         end        
end 

add_hook_script(HOOK_WIELD_SLOT, "__hook_berserk_wear", "__hook_berserk_wear") 


-- Register a new magic type 
MKEY_BERSERK = 205 

add_mkey 
{ 
   ["mkey"] =      MKEY_BERSERK, 
   ["fct"] =       function() 
      execute_magic(BERSERK_MAGIC) 
      energy_use = energy_use + 100; 
   end 
} 
