


-- Script for Generating Age,Height and Weight.
-- Made by Zonk for Ingeborg


	function __birth_stat()

	-- The meaning of this table
	-- Race Name,Base Age,Age Modifier,Male Height Base,Male Height Mod,Male Weight Base,Male Weight Mod,
      -- Female Height Base,Female Height Mod,Female Weight Base,Female Weight Mod

	--R:M:10000:5000:72:6:180:25:66:4:150:20

	local race_birth_table = 
	{
		[1] = {"Jotun",80,40,200,30,5000,750,180,20,4000,500},		
		[2] = {"Angel",10000,5000,72,6,180,25,66,4,150,20},
		[3] = {"Gremlin",10,4,40,5,50,10,35,4,45,10},
		[4] = {"Teddy-Bear",100,40,24,3,50,10,20,2,40,7},
		
	}

	for i = 1,getn(race_birth_table) do
		local t = race_birth_table[i]
		if get_race_name() == t[1] then
			local race = t
			age_base = race[2]
			age_mod = race[3]
			height_male_base = race[4]
			height_male_mod = race[5]
			weight_male_base = race[6]
			weight_male_mod = race[7]
			height_female_base = race[8]
			height_female_mod = race[9]
			weight_female_base = race[10]
			weight_female_mod = race[11]
			break
		end
		if (i == getn(race_birth_table)) then
			return FALSE
		end
	end



	-- SETUP
	player.age = age_base + rand_range(-age_mod,age_mod)
	

	if (player.psex == SEX_MALE) then
		player.ht = height_male_base + rand_range(-height_male_mod,height_male_mod )
		player.wt = weight_male_base + rand_range(-weight_male_mod,weight_male_mod )
	end

	if (player.psex == SEX_FEMALE) then
		player.ht = height_female_base + rand_range(-height_female_mod,height_female_mod )
		player.wt = weight_female_base + rand_range(-weight_female_mod,weight_female_mod )
	end

	if (player.psex == SEX_NEUTER) then
		height_neuter_base = (height_female_base+height_male_base)/2
		height_neuter_mod =  (height_female_mod+height_male_mod)/2

		weight_neuter_base = (weight_female_base+weight_male_base)/2
		weight_neuter_mod =  (weight_female_mod+weight_male_mod)/2

		player.ht = height_neuter_base + rand_range(-height_neuter_mod,height_neuter_mod)
		player.wt = weight_neuter_base + rand_range(-weight_neuter_mod,weight_neuter_mod )
	end


end


add_hook_script(HOOK_BIRTH, "__birth_stat","__birth_stat")



function __hook_calc_weight(weight)
	local multiplier = 100

	if player.wt >= 300 then
		multiplier = 100 + ( (player.wt-300)/10)
	elseif player.wt <= 100 then
		multiplier = 100 - ((100-player.wt)/2)
	end

	if multiplier <= 5 then multiplier = 5 end
	
	local new_weight = (weight * multiplier) / 100
		
	--cmsg_print(TERM_L_RED,"You can carry #G".. new_weight/20 .."#R pounds with a multiplier of #G"..multiplier.."#R.")
	--cmsg_print(TERM_L_RED,"In standard TOME you could carry #G".. weight/20 .."#R pounds.")

	return TRUE, new_weight

end

add_hook_script(HOOK_CALC_WEIGHT, "__hook_calc_weight", "__hook_calc_weight")
