-- snuggle ability for teddies 
-- partly from a script of the Adamant module 

POWER_SNUGGLE = add_power 
{ 
    ["name"] =      "snuggle", 
    ["desc"] =      "You can charm nearby creatures.", 
    ["desc_get"] =  "You suddenly know how to make new friends.", 
    ["desc_lose"] = "You lose your ability to make new friends.", 
    ["level"] =     15, 
    ["cost"] =      5, 
    ["stat"] =      A_CHR, 
    ["fail"] =      20, 
    ["power"] =     function() 

        local plev = player.lev 
        
        if ( plev >= 30) then 
            msg_print("You snuggle up to your new friends.") 
            fire_ball(GF_CHARM, 0, plev, 1) 
        else 
            -- get a direction 
            msg_print("Which direction?") 
            local dir = get_keymap_dir(inkey()) 
            if dir == FALSE then return end 
            local y, x 
            y = player.py + ddy[dir+1] 
            x = player.px + ddx[dir+1] 
  
            local c_ptr = cave(y,x) 
            if c_ptr.m_idx < 1 then 
                msg_print("There is nobody...") 
                return FALSE 
            end                        
            msg_print("You give your new friend a big hug.") 

            project(0, 0, y, x, plev, GF_CHARM, 
                    bor(PROJECT_JUMP, PROJECT_KILL, PROJECT_HIDE)) 
        end 
    end, 
} 


-- Armor Class bonus for Teddy Bears
-- coded by Massimiliano Marangio (many thanks!)

add_hooks { 
    [HOOK_CALC_BONUS] = function() 
        if get_race_name() == "Teddy-Bear" then 
            player.to_a = player.to_a + 5 
            player.dis_to_a = player.dis_to_a + 5 
        end 
    end, 
}

-- Dispel Evil power for Avatars
-- coded by DarkGod (many thanks!)

POWER_DISPEL_EVIL = add_power
{
	["name"] =      "dispel evil",
	["desc"] =      "You are able to dispel evil monsters.",
	["desc_get"] =  "You become able to dispel evil monsters.",
	["desc_lose"] = "You are no longer able to dispel evil monsters.",
	["level"] =     15,
	["cost"] =      20,
	["stat"] =      A_WIS,
	["fail"] =      20,
	["power"] =     function()
		if player.lev < 30 then
			dispel_evil(player.lev * 2)
		elseif player.lev < 45 then
			dispel_evil(player.lev * 3)
		else
			dispel_evil(player.lev * 4)
		end
			
	end,
}