-- handle general celestial powers

BENEDICTION = add_spell
{
	["name"] =      "Benediction",
	["school"] =    {SCHOOL_CELESTIAL},
	["level"] =     1,
	["mana"] =      5,
	["mana_max"] =  50,
	["fail"] = 	20,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			local dur = get_level(BENEDICTION, 70) + 30 + randint(40)
			local obvious

			obvious = set_blessed(dur)
			obvious = is_obvious(set_afraid(0), obvious)
			obvious = is_obvious(set_lite(dur), obvious)
			if get_level(BENEDICTION) >= 10 then
				obvious = is_obvious(set_hero(dur), obvious)
			end
			if get_level(BENEDICTION) >= 20 then
				obvious = is_obvious(set_shero(dur), obvious)
			end
			if get_level(BENEDICTION) >= 30 then
				obvious = is_obvious(set_holy(dur), obvious)
			end
			return obvious
	end,
	["info"] =      function()
			return "dur "..(get_level(BENEDICTION, 70) + 30).."+d40"
	end,
	["desc"] =	{
			"Benediction removes your fears, bless you and surrounds you with",
			"holy light",
			"At level 10 it also grants heroism",
			"At level 20 it also grants super heroism",
			"At level 30 it also grants holy luck and life protection",
	}
}

BREAD_LIFE = add_spell
{
	["name"] = 	"Bread of Life",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	6,
	["mana"] = 	7,
	["mana_max"] = 	15,
	["fail"] = 	35,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = function()
			set_food(PY_FOOD_MAX - 1)
			msg_print("Your faith nourishes you.")
			if get_level(BREAD_LIFE, 50) >= 5 then
				hp_player(25)
			end
		return TRUE
		end,
	["info"] = 	function()
			if get_level(BREAD_LIFE, 50) >= 5 then
				return "cure 25" 
			else
				return ""
			end
	end,
	["desc"] =	{
			"Satisfies hunger",
			"At level 5 it also cures minor damage"
	}
}



C_HEALING = add_spell
{
	["name"] = 	"Cure Wounds",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	10,
	["mana"] = 	15,
	["mana_max"] = 	50,
	["fail"] = 	45,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = function()
			return hp_player(player.mhp * (15 + get_level(C_HEALING, 35)) / 100)
	end,
	["info"] = 	function()
			return "heal "..(15 + get_level(C_HEALING, 35)).."% = "..(player.mhp * (15 + get_level(C_HEALING, 35)) / 100).."hp"
	end,
	["desc"] =	{
			"Heals a percent of hitpoints",
	}
}

C_DISPEVIL = add_spell

{
	["name"] = 	"Dispel Evil",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	25,
	["mana"] = 	45,
	["mana_max"] = 135,
	["fail"] = 	30,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = 	function()
		local level = 15 + get_level(C_DISPEVIL, 50)
		if level < 35 then
			dispel_evil(level * 3)
		elseif level < 45 then
			dispel_evil(level * 4)
		else
			dispel_evil(level * 5)
		end
	return TRUE
	end,
	["info"] = 	function()
		local level = 15 + get_level(C_DISPEVIL, 50)
		if level < 35 then
			return "dam "..(level * 3)
		elseif level < 45 then
			return "dam "..(level * 4)
		else
			return "dam "..(level * 5)
		end

	end,
	["desc"] =	{
			"Dispels evil beings around you"
			}
}


FAITH_HEAL = add_spell
{
	["name"] = 	"Faith Healing",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	15,
	["mana"] = 	25,
	["mana_max"] = 	25,
	["fail"] = 	60,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["blind"] =	FALSE,
	["confusion"] = FALSE,
	["spell"] = 	function()
			local level = get_level(FAITH_HEAL, 50)
			local obvious
			obvious = is_obvious (set_stun(0), obvious)
			obvious = is_obvious (set_cut(0), obvious)
			hp_player(level * 5)
			if level >= 10 then
				obvious = is_obvious(set_blind(0), obvious)
				obvious = is_obvious(set_confused(0), obvious)
			end
			if level >= 20 then
				obvious = is_obvious(do_res_stat(A_STR, TRUE), obvious)
				obvious = is_obvious(do_res_stat(A_CON, TRUE), obvious)
				obvious = is_obvious(do_res_stat(A_DEX, TRUE), obvious)
				obvious = is_obvious(do_res_stat(A_WIS, TRUE), obvious)
				obvious = is_obvious(do_res_stat(A_INT, TRUE), obvious)
				obvious = is_obvious(do_res_stat(A_CHR, TRUE), obvious)
				obvious = is_obvious(restore_level(), obvious)
			end
			if level >= 30 then
				obvious = is_obvious(set_image(0), obvious)
				obvious = is_obvious(set_parasite(0, 0), obvious)
				heal_insanity(level * 5)
			end
			return obvious
	end,
	["info"] = 	function()
			return "heal "..(get_level(FAITH_HEAL, 50) * 5)
	end,
	["desc"] =	{
			"Heals wounds, cures stunning and bleeding",
			"At level 10 it cures blindness and confusion",
			"At level 20 it restores drained stats and levels",
			"At level 30 it cures most other conditions"
	}
}

INTERCESSION= add_spell
{
	["name"] =      "Intercession",
	["school"] = {SCHOOL_CELESTIAL}, 
	["level"] = 45, 
	["mana"] = 25, 
	["mana_max"] = 50, 
	["fail"] = 30, 
	["stat"] =      A_WIS,
	["random"] = -1, 
	["spell"] = function() 
	local level = dun_level 

		if level < 21 then 
		-- boost level to allow summoning of Angels 
		level = 42 - level 

		end 
	summon_specific_level = 25 + get_level(INTERCESSION, 75) 
	return summon_monster(player.py, player.px, level, TRUE, SUMMON_ANGEL) 
	end, 
	["info"] = function() 
	return "level "..(25 + get_level(INTERCESSION, 75)) 
	end, 
	["desc"] = { 
	"Summons a leveled angel to help you battle the forces of evil" 
	} 
}

C_DELCURSES = add_spell
{
	["name"] = 	"Remove Curses",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	10,
	["mana"] = 	20,
	["mana_max"] = 	40,
	["fail"] = 	30,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = function()
			local done

			if get_level(C_DELCURSES, 50) >= 20 then done = remove_all_curse()
			else done = remove_curse() end
			if done == TRUE then msg_print("The curse is broken!") end
			return done
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] =	{
			"Remove curses of worn objects",
			"At level 20 switches to *remove curses*"
		}
}

REVELATION = add_spell

{
	["name"] = 	"Revelation",
	["school"] = 	{SCHOOL_CELESTIAL},
	["level"] = 	1,
	["mana"] = 	3,
	["mana_max"] = 	60,
	["fail"] = 	20,
	["stat"] =      A_WIS,
	-- Unnafected by blindness
	["blind"] =     FALSE,
	["random"] = 	-1,
	["spell"] = 	function()
			local obvious
			obvious = detect_doors(10 + get_level(REVELATION, 40, 0))
			obvious = is_obvious(detect_stairs(10 + get_level(REVELATION, 40, 0)), obvious)
			if get_level(REVELATION) >= 40 then
				detect_all(10 + get_level(REVELATION, 40, 0))
				wiz_lite_extra()
				obvious = TRUE
			elseif get_level(REVELATION) >= 30 then
				detect_all(10 + get_level(REVELATION, 40, 0))
				map_area()
				obvious = TRUE
			elseif get_level(REVELATION) >= 10 then
				map_area()
				obvious = TRUE
			end
			if get_level(REVELATION) >= 20 then
				obvious = is_obvious(set_blind(0), obvious)
			end
			return obvious
	end,
	["info"] = 	function()
			return "rad "..(10 + get_level(REVELATION, 40))
	end,
	["desc"] =	{
			"Allows you to find pathways, stairs and doors",
			"At level 10 it allows you to see your surroundings",
			"At level 20 it allows you to cure blindness",
			"At level 30 it allows you to detect almost everything",
			"At level 40 it allows you to fully see all the level"
	}
}

HOLY_WORD = add_spell
{
	["name"] =      "Holy Word",
	["school"] = {SCHOOL_CELESTIAL}, 
	["level"] = 45, 
	["mana"] = 90, 
	["mana_max"] = 90, 
	["fail"] = 60, 
	["stat"] =      A_WIS,
	["random"] = -1, 
	["spell"] = function() 
      	local level = get_level(HOLY_WORD, 50) 
      	local damage = 25 * level 
      	local obvious = hp_player(5000) 
        	obvious = is_obvious (set_stun(0), obvious) 
         	obvious = is_obvious (set_cut(0), obvious) 
         	obvious = is_obvious (set_afraid(0), obvious) 
         	obvious = is_obvious (dispel_evil(damage), obvious) 
         	return obvious 
   	end, 

	["info"] = 	function()
		local level = get_level(HOLY_WORD, 50)
		return "dam "..(25 * level)
	end,
	["desc"] =	{
			"Dispels evil, removes fear, and heals all wounds"
			}
}

CREATE_LIGHT = add_spell
{
	["name"] =      "Create Light",
	["school"] =    {SCHOOL_CELESTIAL},
	["level"] =     1,
	["mana"] =      2,
	["mana_max"] =  15,
	["fail"] =      10,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] =     function()
		local obvious
		if get_level(CREATE_LIGHT, 50) >= 3 then
			obvious = lite_area(10, 4)
		else
			lite_room(player.py, player.px)
			obvious = TRUE
		end
		if get_level(CREATE_LIGHT, 50) >= 15 then
			obvious = is_obvious(fire_ball(GF_LITE, 0, 10 + get_level(CREATE_LIGHT, 100), 5 + get_level(CREATE_LIGHT, 6)), obvious)
		end
		return obvious
	end,
	["info"] =      function()
		if get_level(CREATE_LIGHT, 50) >= 15 then
			return "dam "..(10 + get_level(CREATE_LIGHT, 100)).." rad "..(5 + get_level(CREATE_LIGHT, 6))
		else
			return ""
		end
	end,
	["desc"] =      {
			"Creates a globe of pure light",
			"At level 3 it starts damaging monsters",
			"At level 15 it starts creating a more powerful kind of light",
	}
}
