-- Handle Crusade celestial powers

CRUSADE_AIM = add_spell
{
	["name"] =      "Divine Aim",
	["school"] =    {SCHOOL_CRUSADE},
	["level"] =     1,
	["mana"] =      6,
	["mana_max"] =  100,
	["fail"] = 	20,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			local dur = get_level(CRUSADE_AIM, 50) + randint(10)
			local obvious

			obvious = set_strike(dur)
			if get_level(CRUSADE_AIM) >= 20 then
				obvious = is_obvious(set_tim_deadly(dur), obvious)
			end
			return obvious
	end,
	["info"] = 	function()
			return "dur "..(get_level(CRUSADE_AIM, 50)).."+d10"
	end,
	["desc"] =	{
			"It makes you more accurate in combat",
			"At level 20 all your blows are critical hits",
	}
}

CRUSADE_WAVE = add_spell
{
	["name"] =      "Wave of Power",
	["school"] =    {SCHOOL_CRUSADE},
	["level"] =     20,
	["mana"] =      50,
	["mana_max"] =  50,
	["fail"] = 	75,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			local ret, dir = get_aim_dir()
			if ret == FALSE then return end

			return fire_bolt(GF_ATTACK, dir, get_level(CRUSADE_WAVE, player.num_blow))
	end,
	["info"] = 	function()
			return "blows "..(get_level(CRUSADE_WAVE, player.num_blow))
	end,
	["desc"] =	{
			"It allows you to project a number of melee blows across a distance",
	}
}

CRUSADE_SPIN = add_spell
{
	["name"] =      "Whirlwind",
	["school"] =    {SCHOOL_CRUSADE},
	["level"] =     10,
	["mana"] =      25,
	["mana_max"] =  25,
	["fail"] = 	45,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			return fire_ball(GF_ATTACK, 0, 1, 1)
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] =	{
			"It allows you to spin around and hit all monsters nearby",
	}
}


CRUSADE_SANCT = add_spell
{
	["name"] =      "Sanctuary",
	["school"] =    {SCHOOL_CRUSADE},
	["level"] =     10,
	["mana"] =      20,
	["mana_max"] =  100,
	["fail"] = 	30,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			local dur = get_level(CRUSADE_SANCT, 50) + 10 + randint(20)
			local obvious

			obvious = set_protevil(dur)
			if get_level(CRUSADE_SANCT) >= 10 then
				local type

				type = 0
				if get_level(CRUSADE_SANCT) >= 20 then
					type = SHIELD_COUNTER
				end
				obvious = is_obvious(set_shield(dur, get_level(CRUSADE_SANCT, 30), type, 1 + get_level(CRUSADE_SANCT, 2), 1 + get_level(CRUSADE_SANCT, 6)), obvious)
			end
			return obvious
	end,
	["info"] = 	function()
			local desc = "dur "..(get_level(CRUSADE_SANCT, 50) + 10).."+d20"

			if get_level(CRUSADE_SANCT) >= 10 then
				desc = desc.." AC "..(get_level(CRUSADE_SANCT, 30))
			end
			if get_level(CRUSADE_SANCT) >= 20 then
				desc = desc.." dam "..(1 + get_level(CRUSADE_SANCT, 2)).."d"..(1 + get_level(CRUSADE_SANCT, 6))
			end
			return desc
	end,
	["desc"] =	{
			"It surrounds you with a holy force that deflects blows from evil monsters",
			"At level 10 it increases your armor rating",
			"At level 20 it retaliates against monsters that melee you",
	}
}

EXORCISM = add_spell 
{ 
   ["name"] =    "Exorcism", 
   ["school"] =    SCHOOL_CRUSADE, 
   ["level"] =    4, 
   ["mana"] =    3, 
   ["mana_max"] =  30, 
   ["fail"] =    10, 
   ["stat"] =      A_WIS, 
   ["random"] =    -1, 
   ["spell"] =    function() 
         local ret, dir    

         ret, dir = get_aim_dir() 
         if (ret == FALSE) then return end 

         local level = 2 + get_level(EXORCISM, 50) 
         local chance = get_level(EXORCISM, 85) 
         local damage = damroll(level, 4) 
         local obvious 
          
         if (level >= 20) then 
            obvious = fire_bolt_or_beam(chance, GF_DISP_EVIL, dir, damage)
         elseif (level >= 10) then 
            obvious = fire_bolt_or_beam(chance, GF_DISP_DEMON, dir, damage) 
         else 
            obvious = fire_bolt(GF_DISP_DEMON, dir, damage) 
         end 
         return obvious 
   end, 

   ["info"] =    function() 
         local level = 2 + get_level(EXORCISM, 50)
         return "dam "..level.."d4" 
   end, 
   ["desc"] =   { 
         "Tries to blast a single demon out of existence", 
         "At level 10 the spell may dispel multiple demons", 
         "At level 20 it affects evil creatures of all kinds" 
      } 
} 


