-- Handle celestial Death powers

-- Adapted from the Sterilize spell on ToMEnet (thanks to Zfang@fangs.freeserve.co.uk); this makes more 
-- sense as a Death spell than as an Air spell IMO...



DENY_LIFE = add_spell

{
	["name"] = 	"Deny New Life",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	20,
	["mana"] = 	10,
	["mana_max"] = 	100,
	["fail"] = 	50,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
		set_no_breeders(randint(30) + 20 + get_level(DENY_LIFE, 200))
       	end,
	["info"] = 	function()
			return "dur "..(20 + get_level(DENY_LIFE, 200)).."+d30"
	end,
	["desc"] =	{
			"Prevents explosive breeding for a while"
	}
}


ETHEREAL = add_spell
{
	["name"] = 	"Ethereality",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	30,
	["mana"] = 	20,
	["mana_max"] = 	40,
	["fail"] = 	95,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = 	function()
		       	return set_shadow(randint(30) + 20 + get_level(ETHEREAL, 40))
	end,
	["info"] = 	function()
			return "dur "..(20 + get_level(ETHEREAL, 40)).."+d30"
	end,
	["desc"] =	{
			"Turns you into an immaterial being",
	}
}


FINGER_DEATH = add_spell

{
	["name"] = 	"Finger of Death",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	20,
	["mana"] = 	40,
	["mana_max"] =  400,
	["fail"] = 	40,
	["stat"] =      A_WIS,
	["random"] = 	-1,

	["spell"] = 	function()
			local ret, dir	

			ret, dir = get_aim_dir()
			if ret == FALSE then return end
			return fire_bolt(GF_INSTA_DEATH, dir, 1)
	end,
	["info"] = 	function()
			return "insta-kill"
	end,
	["desc"] =	{
			"Kills a single creature instantly",
			"You receive only one-third XP credit for the kill"
		}
}

REQUIEM = add_spell
{
	["name"] = 	"Requiem",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	15,
	["mana"] = 	20,
	["mana_max"] = 	60,
	["fail"] = 	45,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = function()
		local level = 10 + get_level (REQUIEM, 50)
		if level < 25 then
			dispel_undead(level * 3)
		elseif level < 35 then
			dispel_undead(level * 4)
		else
			dispel_undead(level * 5)
		end
	return TRUE
	end,

	["info"] = 	function()
		local level = 10 + get_level (REQUIEM, 50)
		if level < 25 then
			return "dam "..(level * 3)
		elseif level < 35 then
			return "dam "..(level * 4)
		else
			return "dam "..(level * 5)
		end

	end,

	["desc"] =	{
			"Dispels undead around you",
	}
}


TURN_UNDEAD = add_spell

{
	["name"] = 	"Turn Undead",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	7,
	["mana"] = 	5,
	["mana_max"] = 	20,
	["fail"] = 	20,
	["stat"] =      A_WIS,
	["random"] =    -1,
	["spell"] = function()
			local ret, dir = get_aim_dir()
			if ret == FALSE then return end
			return fire_ball(GF_AWAY_UNDEAD, dir, 10 + get_level(TURN_UNDEAD, 150), 3)

	end,
	["info"] = 	function()
	return "power "..(10 + get_level(TURN_UNDEAD, 150))
	end,

	["desc"] =	{
			"Terrifies undead into fleeing from you",
	}
}


WRATH_AZRAEL = add_spell
{
	["name"] = 	"Wrath of Azrael",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	25,
	["mana"] = 	50,
	["mana_max"] = 	50,
	["fail"] = 	90,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] = 	function()
			local type

			type = 0
			if get_level(WRATH_AZRAEL) >= 10 then type = 1 end
			if type == 0 then
				genocide(TRUE)
				return TRUE
			else
				if get_check("Genocide all monsters near you? ") == TRUE then
					mass_genocide(TRUE)
				else
					genocide(TRUE)
				end
				return TRUE
			end
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] =	{
			"Genocides all monsters of a race on the level",
			"At level 10 it can genocide all monsters near you"
	}
}



TOUCH_AZRAEL = add_spell
{
	["name"] = 	"Touch of Azrael",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	22,
	["mana"] = 	30,
	["mana_max"] = 	60,
	["fail"] = 	80,
	["random"] = -1,
	["stat"] = A_WIS,
	["spell"] = 	function()
			local type
	
			if get_level(TOUCH_AZRAEL, 50) >= 10 then type = GF_NETHER
			else type = GF_COLD end
			fire_wave(type, 0, 80 + get_level(TOUCH_AZRAEL, 200), 1 + get_level(TOUCH_AZRAEL, 3, 0), 20 + get_level(TOUCH_AZRAEL, 70), EFF_STORM)
			return TRUE
	end,
	["info"] = 	function()
			return "dam "..(80 + get_level(TOUCH_AZRAEL, 200)).." rad "..(1 + get_level(TOUCH_AZRAEL, 3, 0)).." dur "..(20 + get_level(TOUCH_AZRAEL, 70))
	end,
	["desc"] =	{
			"Surrounds you with bone-chilling cold",
			"At level 10 the aura inflicts nether damage"
	}
}

LIFE_QUENCH= add_spell 
{ 
   ["name"] =    "Life Quench", 
   ["school"] =    SCHOOL_DEATH, 
   ["level"] =    4, 
   ["mana"] =    3, 
   ["mana_max"] =  30, 
   ["fail"] =    10, 
   ["stat"] =      A_WIS, 
   ["random"] =    -1, 
   ["spell"] =    function() 
         local ret, dir    

         ret, dir = get_aim_dir() 
         if (ret == FALSE) then return end 

         local level = 2 + get_level(LIFE_QUENCH, 50) 
         local chance = get_level(LIFE_QUENCH, 85) 
         local damage = damroll(level, 6) 
         local obvious 
          
         if (level >= 20) then 
            obvious = fire_bolt_or_beam(chance, GF_NETHER, dir, damage/2) 
            obvious = is_obvious(fire_bolt_or_beam(chance, GF_DISP_LIVING, dir, damage), obvious) 
         elseif (level >= 10) then 
            obvious = fire_bolt_or_beam(chance, GF_DISP_LIVING, dir, damage) 
         else 
            obvious = fire_bolt(GF_DISP_LIVING, dir, damage) 
         end 
         return obvious 
   end, 

   ["info"] =    function() 
         local level = 2 + get_level(LIFE_QUENCH, 50) 
          
         if (level >= 20) then 
             return "dam "..(3*level/2).."d6" 
         else 
             return "dam "..level.."d6" 
         end 
   end, 
   ["desc"] =   { 
         "Releases a life-destroying bolt of energy", 
         "At level 10 the energy may harm other opponents", 
         "At level 20 it also inflicts nether damage" 
      } 
} 

CALL_SOUL= add_spell

{
	["name"] = 	"Call Blessed Soul",
	["school"] = 	{SCHOOL_DEATH},
	["level"] = 	10,
	["mana"] = 	25,
	["mana_max"] = 	50,
	["fail"] = 	90,
	["stat"] =      A_WIS,
	["random"] = 	-1,
	["spell"] =     function()
			local y, x, m_idx
			local summons =
				{
				test_monster_name("Child spirit"),
				test_monster_name("Young spirit"),
				}
			y, x = find_position(player.py, player.px)
			m_idx = place_monster_one(y, x, summons[rand_range(1, 2)], 0, FALSE, MSTATUS_FRIEND)
			if m_idx ~= 0 then
				monster_set_level(m_idx, 20 + get_level(CALL_SOUL, 70, 0))
				return TRUE
			end
	end,

	["info"] = 	function()
			return "level "..(get_level(CALL_SOUL, 70))
	end,
	["desc"] =	{
			"Summons a leveled spirit of the benevolent dead",
			"to fight for you"

	}
}

