-- Handle Divine-voice celestial powers

DVOICE_PEACE = add_spell
{
	["name"] = 	"Song of Peace",
	["school"] = 	{SCHOOL_DVOICE},
	["level"] = 	1,
	["mana"] = 	1,
	["mana_max"] = 	20,
	["fail"] = 	10,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["spell"] = 	function()
			if get_level(DVOICE_PEACE, 50) >= 35 then
				return project_los(GF_CHARM, 10 + get_level(DVOICE_PEACE, 150))
			elseif get_level(DVOICE_PEACE, 50) >= 15 then
				local ret, dir = get_aim_dir()
				if ret == FALSE then return end
				return fire_ball(GF_CHARM, dir, 10 + get_level(DVOICE_PEACE, 150), 3)
			else
				local ret, dir = get_aim_dir()
				if ret == FALSE then return end
				return fire_bolt(GF_CHARM, dir, 10 + get_level(DVOICE_PEACE, 150))
			end
	end,
	["info"] = 	function()
			return "power "..(10 + get_level(DVOICE_PEACE, 150))
	end,
	["desc"] =	{
			"Tries to calm and befriend a monster with your voice",
			"At level 15 it turns into a ball",
			"At level 35 it affects all monsters in sight"
			}
}

DVOICE_REBUKE = add_spell

{
	["name"] = 	"Song of Rebuke",
	["school"] = 	{SCHOOL_DVOICE},
	["level"] = 	10,
	["mana"] = 	5,
	["mana_max"] = 	20,
	["fail"] = 	20,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["spell"] = function()
			local ret, dir = get_aim_dir()
			if ret == FALSE then return end
			return fire_ball(GF_AWAY_ALL, dir, 10 + get_level(DVOICE_REBUKE, 150), 3)

	end,
	["info"] = 	function()
	return "power "..(10 + get_level(DVOICE_REBUKE, 150))
	end,

	["desc"] =	{
			"Shames monsters into fleeing from you",
	}
}



DVOICE_BANISH = add_spell
{
	["name"] = 	"Song of Banishment",
	["school"] = 	{SCHOOL_DVOICE},
	["level"] = 	15,
	["mana"] = 	30,
	["mana_max"] = 	90,
	["fail"] = 	60,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["spell"] = 	function()
			local obvious
			obvious = project_los(GF_AWAY_EVIL, 40 + get_level(DVOICE_BANISH, 160))
			return obvious
	end,
	["info"] = 	function()
		     	return "power "..(40 + get_level(DVOICE_BANISH, 160))
	end,
	["desc"] =	{
			"Banishes evil beings from your line of sight",
	}
}


DVOICE_THUNDER = add_spell
{
	["name"] =      "Voice of Thunder",
	["school"] =    {SCHOOL_DVOICE},
	["level"] =     7,
	["mana"] =      5,
	["mana_max"] =  50,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["blind"] =      FALSE,
	["spell"] =     function()
			fire_ball(GF_SOUND,
				  0,
				  damroll(2 + get_level(DVOICE_THUNDER, 10, 0), 4 + get_level(DVOICE_THUNDER, 40, 0)),
				  1 + get_level(DVOICE_THUNDER, 12, 0)
				 )
			return TRUE
	end,
	["info"] =      function()
			return "dam "..(2 + get_level(DVOICE_THUNDER, 10, 0)).."d"..(4 + get_level(DVOICE_THUNDER, 40, 0)).." rad "..(1 + get_level(MUSIC_BLOW, 12, 0))
	end,
	["desc"] =      {
			"Greatly amplifies your voice all around you.",
	}
}

DVOICE_CREATE = add_spell

{
	["name"] =      "Song of Creation",
	["school"] =    {SCHOOL_DVOICE},
	["level"] =     30,
	["mana"] =      70,
	["mana_max"] =  70,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["blind"] =      FALSE,
	["spell"] =     function()
			alter_reality()
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Reshapes the world with your voice, sending you to a nearly",
			"identical reality.",
	}
}

DVOICE_CALL = add_spell

{
	["name"] = 	"Call the Faithful",
	["school"] = 	{SCHOOL_DVOICE},
	["level"] = 	10,
	["mana"] = 	25,
	["mana_max"] = 	50,
	["fail"] = 	90,
	["stat"] =      A_CHR,
	["random"] = 	-1,
	["blind"] =      FALSE,
	["spell"] =     function()
	local m_idx, y, x
	local nb = damroll(get_level(DVOICE_CALL, 10), 5)
	local summons =
	{
	test_monster_name("Novice Priest"),
	test_monster_name("Novice Paladin"),
	}

	for i = 1, nb do
	-- Summon it
		y, x = find_position(player.py, player.px)
		m_idx = place_monster_one(y, x, summons[rand_range(1, 2)], 0, FALSE, MSTATUS_FRIEND)

	-- level it
			if m_idx ~= 0 then
			monster_set_level(m_idx, get_level(DVOICE_CALL, 70))
			end
		end
		return TRUE
	end,
	["info"] = 	function()
			return "level "..(get_level(DVOICE_CALL, 70))
	end,
	["desc"] =	{
			"Summons leveled paladins or priests to fight for you",
	}
}

DVOICE_AWE = add_spell 
{ 
   ["name"] =    "Voice of Awe", 
   ["school"] =    SCHOOL_DVOICE, 
   ["level"] =    4, 
   ["mana"] =    3, 
   ["mana_max"] =  30, 
   ["fail"] =    10, 
   ["stat"] =      A_CHR, 
   ["random"] =    -1, 
   ["spell"] =    function() 
         local ret, dir    

         ret, dir = get_aim_dir() 
         if (ret == FALSE) then return end 

         local level = 2 + get_level(DVOICE_AWE, 50) 
         local chance = get_level(DVOICE_AWE, 85) 
         local damage = damroll(level, 4) 
         local obvious 
          
         if (level >= 20) then 
            obvious = fire_bolt_or_beam(chance, GF_DISP_EVIL, dir, damage/2) 
            obvious = is_obvious(fire_bolt_or_beam(chance, GF_SOUND, dir, damage), obvious) 
         elseif (level >= 10) then 
            obvious = fire_bolt_or_beam(chance, GF_SOUND, dir, damage) 
         else 
            obvious = fire_bolt(GF_SOUND, dir, damage) 
         end 
         return obvious 
   end, 

   ["info"] =    function() 
         local level = 2 + get_level(DVOICE_AWE, 50) 
          
         if (level >= 20) then 
             return "dam "..(3*level/2).."d4" 
         else 
             return "dam "..level.."d4" 
         end 
   end, 
   ["desc"] =   { 
         "Stuns one opponent with a powerful note", 
         "At level 10 the sound may reach other opponents", 
         "At level 20 it also dispels evil beings" 
      } 
} 

DVOICE_WRATH = add_spell
{
	["name"] =      "Voice of Wrath",
	["school"] =    {SCHOOL_DVOICE},
	["level"] =     30,
	["mana"] =      25,
	["mana_max"] =  75,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    -1,
	["spell"] =     function()
			fire_ball(GF_DISINTEGRATE,
				  0,
				  damroll(4 + get_level(DVOICE_WRATH, 20, 0), 6 + get_level(DVOICE_WRATH, 50, 0)),
				  2 + get_level(DVOICE_WRATH, 22, 0)
				 )
			return TRUE
	end,
	["info"] =      function()
			return "dam "..(2 + get_level(DVOICE_WRATH, 20, 0)).."d"..(4 + get_level(DVOICE_WRATH, 50, 0)).." rad "..(1 + get_level(MUSIC_BLOW, 22, 0))
	end,
	["desc"] =      {
			"Disintegrates everything around you with",
			"powerful vibrations.",
	}
}



