-- handle Fire Angels' spells

ARROW_GLORY = add_spell 
{ 
   ["name"] =    "Arrow of Glory", 
   ["school"] =    SCHOOL_HOLYFIRE, 
   ["level"] =    4, 
   ["mana"] =    3, 
   ["mana_max"] =  30, 
   ["fail"] =    10, 
   ["stat"] =      A_WIS, 
   ["random"] =	 -1, 
   ["spell"] =    function() 
         local ret, dir    

         ret, dir = get_aim_dir() 
         if (ret == FALSE) then return end 

         local level = 2 + get_level(ARROW_GLORY, 50) 
         local chance = get_level(ARROW_GLORY, 85) 
         local damage = damroll(level, 4) 
         local obvious 
          
         if (level >= 20) then 
            obvious = fire_bolt_or_beam(chance, GF_HOLY_FIRE, dir, damage/2) 
            obvious = is_obvious(fire_bolt_or_beam(chance, GF_LITE, dir, damage), obvious) 
         elseif (level >= 10) then 
            obvious = fire_bolt_or_beam(chance, GF_LITE, dir, damage) 
         else 
            obvious = fire_bolt(GF_LITE, dir, damage) 
         end 
         return obvious 
   end, 

   ["info"] =    function() 
         local level = 2 + get_level(ARROW_GLORY, 50) 
          
         if (level >= 20) then 
             return "dam "..(3*level/2).."d4" 
         else 
             return "dam "..level.."d4" 
         end 
   end, 
   ["desc"] =   { 
         "Concentrates bright light into a powerful bolt", 
         "At level 10 the light may pierce other opponents", 
         "At level 20 it also inflicts holy fire damage" 
      } 
} 


WINGS_FLAME = add_spell
{
	["name"] = 	"Wings of Flame",
	["school"] = 	{SCHOOL_HOLYFIRE},
	["level"] = 	22,
	["mana"] = 	30,
	["mana_max"] = 	60,
	["fail"] = 	80,
	["random"] =	 -1,
	["stat"] = A_WIS,
	["spell"] = 	function()
			local type
	
			if get_level(WINGS_FLAME, 50) >= 10 then type = GF_HOLY_FIRE
			else type = GF_FIRE end
			fire_wave(type, 0, 80 + get_level(WINGS_FLAME, 200), 1 + get_level(WINGS_FLAME, 3, 0), 20 + get_level(WINGS_FLAME, 70), EFF_STORM)
			return TRUE
	end,
	["info"] = 	function()
			return "dam "..(80 + get_level(WINGS_FLAME, 200)).." rad "..(1 + get_level(WINGS_FLAME, 3, 0)).." dur "..(20 + get_level(WINGS_FLAME, 70))
	end,
	["desc"] =	{
			"Turns your wings into weapons of living fire",
			"At level 10 they become holy fire"
	}
}

SWORD_URIEL= add_spell
{
	["name"] =      "Sword of Uriel",
	["school"] =    {SCHOOL_HOLYFIRE},
	["level"] =     1,
	["mana"] =      4,
	["mana_max"] =  44,
	["fail"] =      20,
	["stat"] =      A_WIS,
	["random"] =	 -1,
	["spell"] =     function()
			local type, rad

			type = GF_FIRE
			if get_level(SWORD_URIEL) >= 30 then type = GF_HOLY_FIRE end

			rad = 0
			if get_level(SWORD_URIEL) >= 45 then rad = 1 end

			return set_project(randint(20) + get_level(SWORD_URIEL, 80),
				    type,
				    4 + get_level(SWORD_URIEL, 40),
				    rad,
				    bor(PROJECT_STOP, PROJECT_KILL))
	end,
	["info"] =      function()
			return "dur "..(get_level(SWORD_URIEL, 80)).."+d20 dam "..(4 + get_level(SWORD_URIEL, 40)).."/blow"
	end,
	["desc"] =      {
			"Imbues your blade with fire to deal more damage",
			"At level 30 it deals holy fire damage",
			"At level 45 it spreads over a 1 radius zone around your target",
	}
}

WRATH_URIEL = add_spell
{
	["name"] =      "Wrath of Uriel",
	["school"] =    {SCHOOL_HOLYFIRE},
	["level"] =     10,
	["mana"] =      5,
	["mana_max"] =  70,
	["fail"] =      35,
	["stat"] =      A_WIS,
	["random"] =	 -1,
	["spell"] =     function()
		local ret, dir, type
		if (get_level(WRATH_URIEL, 50) >= 20) then
			type = GF_HOLY_FIRE
		else
			type = GF_FIRE
		end
		ret, dir = get_aim_dir()
		if ret == FALSE then return end
		return fire_ball(type, dir, 20 + get_level(WRATH_URIEL, 500), 2 + get_level(WRATH_URIEL, 5))
	end,
	["info"] =      function()
		return "dam "..(20 + get_level(WRATH_URIEL, 500)).." rad "..(2 + get_level(WRATH_URIEL, 5))
	end,
	["desc"] =      {
			"Conjures a ball of fire to burn your foes to ashes",
			"At level 20 it turns into a ball of holy fire"
	}
}

HOLY_BLAZE = add_spell
{
	["name"] =      "Holy Blaze",
	["school"] =    {SCHOOL_HOLYFIRE},
	["level"] =     15,
	["mana"] =      25,
	["mana_max"] =  100,
	["fail"] =      40,
	["stat"] =      A_WIS,
	["random"] =	 -1,
	["spell"] =     function()
		local ret, dir, type
		if (get_level(HOLY_BLAZE, 50) >= 6) then
			type = GF_HOLY_FIRE
		else
			type = GF_FIRE
		end
		ret, dir = get_aim_dir()
		if ret == FALSE then return end
		fire_wall(type, dir, 40 + get_level(HOLY_BLAZE, 150), 10 + get_level(HOLY_BLAZE, 14))
		return TRUE
	end,
	["info"] =      function()
		return "dam "..(40 + get_level(HOLY_BLAZE, 150)).." dur "..(10 + get_level(HOLY_BLAZE, 14))
	end,
	["desc"] =      {
			"Creates a fiery wall to incinerate monsters stupid enough to attack you",
			"At level 6 it turns into a wall of holy fire"
	}
}


