MEDITATION = add_spell 
{
   ["name"] =      "Meditation", 
   ["school"] =    {SCHOOL_MEDITATE}, 
   ["random"] =	 -1,
   ["level"] =     1, 
   ["mana"] =      1, 
   ["mana_max"] =  25, 
   ["fail"] =       0, 
   ["stat"] =      A_WIS, 
   ["blind"] =     FALSE, 
   ["spell"] =     function() 
      -- No other lasting spell: Start the meditation 
      if (player.music_extra == 0) then 
         msg_print("You start meditating.") 
         player.start_lasting_spell(MEDITATION) 
      else 
      -- Stop the lasting spell first 
         msg_print("You stop your spell.") 
         player.start_lasting_spell(0) 
      end 
      return TRUE 
   end, 
   ["lasting"] = function() 
      local plev = get_level(MEDITATION) 
      local power = plev * plev /10 
      heal_insanity(power) 
      if (plev >=  5) then hp_player(power) end 
      if (plev >= 10) then set_cut(0) end 
      if (plev >= 20) then set_poisoned(0) end 
      if (plev >= 30) then 
         do_res_stat(A_STR, TRUE) 
         do_res_stat(A_CON, TRUE) 
         do_res_stat(A_DEX, TRUE) 
         do_res_stat(A_WIS, TRUE) 
         do_res_stat(A_INT, TRUE) 
         do_res_stat(A_CHR, TRUE) 
      end 
      if (plev >= 40) then restore_level() end 
      -- returns the mana cost of the lasting spell 
      return get_mana(MEDITATION) 
   end, 
   ["info"] = function() 
         local plev = get_level(MEDITATION) 
         return "power "..plev*plev/10 
   end, 
   ["desc"] = { 
         "The caster focuses their mind upon healing body and mind.", 
         "Heals some sanity.", 
         "At level 5 also heals some wounds.", 
         "At level 10 also cures cuts.", 
         "At level 20 also cures poison.", 
         "At level 30 also restores drained stats.", 
         "At level 40 also restores lost experience." 
   } 
}