-- handle the music school
-- *ALL* lasting spell must return the mana cost in the lasting function

MUSIC_STOP = add_spell
{
	["name"] =      "Stop singing(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     1,
	["mana"] =      0,
	["mana_max"] =  0,
	["fail"] =      -400,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      1,
	["blind"] =     FALSE,
	["spell"] =     function()
			player.start_lasting_spell(0)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Stops the current song, if any."
	}
}

--- Drums
MUSIC_HOLD = add_spell
{
	["name"] =      "Holding Pattern(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     1,
	["mana"] =      1,
	["mana_max"] =  10,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      1,
	["blind"] =     FALSE,
	["lasting"] =   function()
			project_los(GF_OLD_SLOW, 10 + get_level(MUSIC_HOLD, 100))
			return get_mana(MUSIC_HOLD)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_HOLD)
			return TRUE
	end,
	["info"] =      function()
			return "power "..(10 + get_level(MUSIC_HOLD, 100))
	end,
	["desc"] =      {
			"Slows down all monsters listening the song.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_CONF = add_spell
{
	["name"] =      "Illusion Pattern(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     5,
	["mana"] =      2,
	["mana_max"] =  15,
	["fail"] =      30,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["blind"] =     FALSE,
	["lasting"] =   function()
			project_los(GF_OLD_CONF, 10 + get_level(MUSIC_CONF, 100))
			return get_mana(MUSIC_CONF)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_CONF)
			return TRUE
	end,
	["info"] =      function()
			return "power "..(10 + get_level(MUSIC_CONF, 100))
	end,
	["desc"] =      {
			"Tries to confuse all monsters listening the song.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_STUN = add_spell
{
	["name"] =      "Stun Pattern(IV)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     10,
	["mana"] =      3,
	["mana_max"] =  25,
	["fail"] =      45,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      4,
	["blind"] =     FALSE,
	["lasting"] =   function()
			project_los(GF_STUN, 10 + get_level(MUSIC_STUN, 90))
			return get_mana(MUSIC_STUN)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_STUN)
			return TRUE
	end,
	["info"] =      function()
			return "power "..(10 + get_level(MUSIC_STUN, 90))
	end,
	["desc"] =      {
			"Stuns all monsters listening the song.",
			"Consumes the amount of mana each turn.",
	}
}

--- Harps
MUSIC_LITE = add_spell
{
	["name"] =      "Song of the Sun(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     1,
	["mana"] =      1,
	["mana_max"] =  1,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["blind"] =     FALSE,
	["pval"] =      1,
	["lasting"] =   function()
			set_lite(5)
			return 1
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_LITE)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Provides light as long as you sing.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_HEAL = add_spell
{
	["name"] =      "Flow of Life(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     7,
	["mana"] =      5,
	["mana_max"] =  30,
	["fail"] =      35,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["lasting"] =   function()
			hp_player(7 + get_level(MUSIC_HEAL, 100))
			return get_mana(MUSIC_HEAL)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_HEAL)
			return TRUE
	end,
	["info"] =      function()
			return "heal "..(7 + get_level(MUSIC_HEAL, 100)).."/turn"
	end,
	["desc"] =      {
			"Heals you as long as you sing.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_HERO = add_spell
{
	["name"] =      "Heroic Ballad(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     10,
	["mana"] =      4,
	["mana_max"] =  14,
	["fail"] =      45,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["lasting"] =   function()
			set_hero(5)
			if get_level(MUSIC_HERO) >= 10 then
				set_shero(5)
			end
			if get_level(MUSIC_HERO) >= 20 then
				set_strike(5)
			end
			if get_level(MUSIC_HERO) >= 25 then
				set_oppose_cc(5)
			end
			return get_mana(MUSIC_HERO)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_HERO)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Increases melee accuracy",
			"At level 10 it increases it even more and reduces armour a bit",
			"At level 20 it increases it again",
			"At level 25 it grants protection against chaos and confusion",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_TIME = add_spell
{
	["name"] =      "Hobbit Melodies(III)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     20,
	["mana"] =      10,
	["mana_max"] =  30,
	["fail"] =      70,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      3,
	["lasting"] =   function()
			set_shield(5, 10 + get_level(MUSIC_TIME, 50), 0, 0, 0)
			if get_level(MUSIC_TIME) >= 15 then
				set_fast(5, 7 + get_level(MUSIC_TIME, 10))
			end
			return get_mana(MUSIC_TIME)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_TIME)
			return TRUE
	end,
	["info"] =      function()
			if get_level(MUSIC_TIME) >= 15 then
				return "AC "..(10 + get_level(MUSIC_TIME, 50)).." speed "..(7 + get_level(MUSIC_TIME, 10))
			else
				return "AC "..(10 + get_level(MUSIC_TIME, 50))
			end
	end,
	["desc"] =      {
			"Greatly increases your reflexes allowing you to block more melee blows.",
			"At level 15 it also makes you faster.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_MIND = add_spell
{
	["name"] =      "Clairaudience(IV)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     25,
	["mana"] =      15,
	["mana_max"] =  30,
	["fail"] =      75,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      4,
	["lasting"] =   function()
			set_tim_esp(5)
			if get_level(MUSIC_MIND) >= 10 then
				fire_ball(GF_IDENTIFY, 0, 1, 1 + get_level(MUSIC_MIND, 3, 0))
			end
			return get_mana(MUSIC_MIND)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_MIND)
			return TRUE
	end,
	["info"] =      function()
			if get_level(MUSIC_MIND) >= 10 then
				return "rad "..(1 + get_level(MUSIC_MIND, 3, 0))
			else
				return ""
			end
	end,
	["desc"] =      {
			"Allows you to sense monster minds as long as you sing.",
			"At level 10 it identifies all objects in a radius on the floor,",
			"as well as probing monsters in that radius.",
			"Consumes the amount of mana each turn.",
	}
}

--- Horns

MUSIC_BLOW = add_spell
{
	["name"] =      "Blow(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     4,
	["mana"] =      3,
	["mana_max"] =  30,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      1,
	["spell"] =     function()
			fire_ball(GF_SOUND,
				  0,
				  damroll(2 + get_level(MUSIC_BLOW, 10, 0), 4 + get_level(MUSIC_BLOW, 40, 0)),
				  1 + get_level(MUSIC_BLOW, 12, 0)
				 )
			return TRUE
	end,
	["info"] =      function()
			return "dam "..(2 + get_level(MUSIC_BLOW, 10, 0)).."d"..(4 + get_level(MUSIC_BLOW, 40, 0)).." rad "..(1 + get_level(MUSIC_BLOW, 12, 0))
	end,
	["desc"] =      {
			"Produces a powerful, blowing, sound all around you.",
	}
}

MUSIC_WIND = add_spell
{
	["name"] =      "Gush of Wind(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     14,
	["mana"] =      15,
	["mana_max"] =  45,
	["fail"] =      30,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["spell"] =     function()
			fire_ball(GF_AWAY_ALL,
				  0,
				  10 + get_level(MUSIC_BLOW, 40, 0),
				  1 + get_level(MUSIC_BLOW, 12, 0)
				 )
			return TRUE
	end,
	["info"] =      function()
			return "dist "..(10 + get_level(MUSIC_BLOW, 40, 0)).." rad "..(1 + get_level(MUSIC_BLOW, 12, 0))
	end,
	["desc"] =      {
			"Produces an outgoing gush of wind that sends monsters away.",
	}
}

MUSIC_YLMIR = add_spell
{
	["name"] =      "Horns of Ylmir(III)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     20,
	["mana"] =      25,
	["mana_max"] =  30,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      3,
	["spell"] =     function()
			earthquake(player.py, player.px, 2 + get_level(SHAKE, 10))
			return TRUE
	end,
	["info"] =      function()
			return "rad "..(2 + get_level(SHAKE, 10))
	end,
	["desc"] =      {
			"Produces an earth shaking sound.",
	}
}

MUSIC_AMBARKANTA = add_spell
{
	["name"] =      "Ambarkanta(IV)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     25,
	["mana"] =      70,
	["mana_max"] =  70,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      4,
	["spell"] =     function()
			alter_reality()
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Produces a reality shaking sound that transports you to a nearly",
			"identical reality.",
	}
}

MUSIC_UNMAKE = add_spell
{
	["name"] =      "Unmaking Blast(IV)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     25,
	["mana"] =      25,
	["mana_max"] =  75,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      4,
	["spell"] =     function()
			fire_ball(GF_DISINTEGRATE,
				  0,
				  damroll(4 + get_level(MUSIC_UNMAKE, 20, 0), 6 + get_level(MUSIC_UNMAKE, 50, 0)),
				  2 + get_level(MUSIC_UNMAKE, 22, 0)
				 )
			return TRUE
	end,
	["info"] =      function()
			return "dam "..(2 + get_level(MUSIC_UNMAKE, 20, 0)).."d"..(4 + get_level(MUSIC_UNMAKE, 50, 0)).." rad "..(1 + get_level(MUSIC_BLOW, 22, 0))
	end,
	["desc"] =      {
			"Disintegrates everything around you with",
			"powerful vibrations.",
	}
}


MUSIC_BLESS = add_spell
{
	["name"] =      "Canticle(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     5,
	["mana"] =      3,
	["mana_max"] =  15,
	["fail"] =      45,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["blind"] =     FALSE,
	["lasting"] =   function()
			set_blessed(5)
			if get_level(MUSIC_BLESS) >= 10 then
				set_protevil(5)
			end
			if get_level(MUSIC_BLESS) >= 20 then
				set_holy(5)
			end
			return get_mana(MUSIC_BLESS)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_BLESS)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Blesses the caster while the song continues",
			"At level 10 it also protects from evil",
			"At level 20 it grants holy luck and life protection",
			"Consumes the amount of mana each turn.",
	}
}


MUSIC_RESTIME = add_spell
{
	["name"] =      "Eternal Pattern(IV)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     25,
	["mana"] =      7,
	["mana_max"] =  15,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      4,
	["blind"] =     FALSE,
	["lasting"] =   function()
			set_tim_res_time(5)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_RESTIME)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"Stabilizes space-time around the musician.",
			"Consumes the amount of mana each turn.",
	}
}

MUSIC_MACABRE = add_spell
{
	["name"] =      "Danse Macabre(III)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     15,
	["mana"] =      5,
	["mana_max"] =  25,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      3,
	["lasting"] =   function()
			project_los(GF_CONTROL_UNDEAD, 25 + get_level(MUSIC_MACABRE, 100))
			return get_mana(MUSIC_MACABRE)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_MACABRE)
			return TRUE
	end,
	["info"] =      function()
			return "power "..(25 + get_level(MUSIC_MACABRE, 100))
	end,
	["desc"] =      {
			"Tries to control all undead within earshot.",
			"Consumes the amount of mana each turn.",
	}
}


MUSIC_DOOM = add_spell 
{ 
   ["name"] =      "Trumpet of Doom(III)", 
   ["school"] =    {SCHOOL_MUSIC}, 
   ["level"] =     20, 
   ["mana"] =      15, 
   ["mana_max"] =  45, 
   ["fail"] =      60, 
   ["stat"] =      A_CHR, 
   ["random"] =    SKILL_MUSIC, 
   ["pval"] =      3, 
   ["spell"] =     function() 
         local level = 10 + get_level(MUSIC_DOOM, 50) 
         local rad = level/10 
         local power = 5 * level 
         fire_ball(GF_RAISE, 0, power, rad) 
         return TRUE 
   end, 
   ["info"] =      function() 
         local level = 10 + get_level(MUSIC_DOOM, 50) 
         local rad = level/10 
         local power = 5 * level 
         return "power "..power.." rad "..rad 
   end, 
   ["desc"] =      { 
         "Raises undead servants around the musician.", 
   } 
} 
-- If the elves called this Vala the "Hornblower" and he actively fought evil in Arda, a 
-- spell like this makes sense...ISN

MUSIC_OROME = add_spell 
{ 
   ["name"] =      "Horn of Orome(III)", 
   ["school"] =    {SCHOOL_MUSIC},
   ["level"] =     20, 
   ["mana"] =      15, 
   ["mana_max"] =  45, 
   ["fail"] =      75, 
   ["stat"] =      A_CHR, 
   ["random"] =    SKILL_MUSIC, 
   ["pval"] =      3, 
   ["spell"] =     function() 
         local level = 10 + get_level(MUSIC_OROME, 50) 
         local rad = level/10 
         local power = 5 * level 
         fire_ball(GF_DISP_EVIL, 0, power, rad) 
         return TRUE 
   end, 
   ["info"] =      function() 
         local level = 10 + get_level(MUSIC_OROME, 50) 
         local rad = level/10 
         local power = 5 * level 
         return "power "..power.." rad "..rad 
   end, 
   ["desc"] =      { 
         "Dispels evil around the musician.", 
   } 
} 

-- Radagast was a nature-mage among the Istari, so dedicating a charm-animal song to him 
-- sounds reasonable! (ISN)

MUSIC_RADAGAST = add_spell
{
	["name"] =      "Lay of Radagast(III)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     20,
	["mana"] =      7,
	["mana_max"] =  15,
	["fail"] =      60,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      3,
	["lasting"] =   function()
			project_los(GF_CONTROL_ANIMAL, 25 + get_level(MUSIC_RADAGAST, 100))
			return get_mana(MUSIC_RADAGAST)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_RADAGAST)
			return TRUE
	end,
	["info"] =      function()
			return "power "..(25 + get_level(MUSIC_RADAGAST, 100))
	end,
	["desc"] =      {
			"Tries to charm all animals within earshot.",
			"Consumes the amount of mana each turn.",
	}
}

-- If Tom Bombadil used music to fend off a Barrow-wight, why *not* name an anti-undead 
-- song for him?--ISN

MUSIC_BOMBADIL = add_spell
{
	["name"] =      "Bombadil's Chant(II)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     10,
	["mana"] =      3,
	["mana_max"] =  15,
	["fail"] =      45,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      2,
	["lasting"] =   function()
			local level = get_level(MUSIC_BOMBADIL, 50)
			set_protundead(5)
			if level >= 10 then
				set_holy(5)
			end
			if level >= 20 then
				project_los(GF_AWAY_UNDEAD, 25 + get_level(MUSIC_BOMBADIL, 100))
			end
			return get_mana(MUSIC_BOMBADIL)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_BOMBADIL)
			return TRUE
	end,
	["info"] =      function()
			local level = get_level(MUSIC_BOMBADIL, 50)
			if level >= 20 then
				return "power "..(25 + get_level(MUSIC_BOMBADIL, 100))
			else
				return ""
			end
	end,
	["desc"] =      {
			"Protects the musician from undead.",
			"At level 10, grants holy luck and life protection.",
			"At level 20, banishes all undead within earshot.",
	}
}

--[[
MUSIC_ = add_spell
{
	["name"] =      "(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     1,
	["mana"] =      0,
	["mana_max"] =  0,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      1,
	["lasting"] =   function()
			return get_mana(MUSIC_)
	end,
	["spell"] =     function()
			player.start_lasting_spell(MUSIC_)
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"",
			"Consumes the amount of mana each turn.",
	}
}

or

MUSIC_ = add_spell
{
	["name"] =      "(I)",
	["school"] =    {SCHOOL_MUSIC},
	["level"] =     1,
	["mana"] =      0,
	["mana_max"] =  0,
	["fail"] =      20,
	["stat"] =      A_CHR,
	["random"] =    SKILL_MUSIC,
	["pval"] =      1,
	["spell"] =     function()
			
			return TRUE
	end,
	["info"] =      function()
			return ""
	end,
	["desc"] =      {
			"",
	}
}
]]
